#include "BowerMesh.h"



BowerMesh::BowerMesh()
{
	//Default values
	SetScale(1.0f);
	SetRotation(0.0f);
	SetPosition(0.0f, 0.0f, 0.0f);
}


BowerMesh::~BowerMesh()
{
	
}

void BowerMesh::SetPosition(XMFLOAT3 position)
{
	//Position affects transform matrix
	_TransformMatrix = DirectX::XMMatrixTranslation(position.x, position.y, position.z);
}

void BowerMesh::SetPosition(float x, float y, float z)
{
	//Position affects transform matrix
	_TransformMatrix = DirectX::XMMatrixTranslation(x, y, z);
}

XMMATRIX BowerMesh::GetWorldMatrix()
{
	//SRT multiplcation produces world matrix
	XMMATRIX srMatrix = DirectX::XMMatrixMultiply(_ScaleMatrix, _TransformMatrix);
	_WorldMatrix = DirectX::XMMatrixMultiply(srMatrix, _RotationMatrix);
	return _WorldMatrix;
}

void BowerMesh::SetScale(float scale)
{
	//Scale affects scale matrix
	_ScaleMatrix = DirectX::XMMatrixScaling(scale, scale, scale);
}

void BowerMesh::SetScale(float scaleX, float scaleY, float scaleZ)
{
	//Scale affects scale matrix
	_ScaleMatrix = DirectX::XMMatrixScaling(scaleX, scaleY, scaleZ);
}

void BowerMesh::SetRotation(float rot)
{
	//Rotation affects rotation matrix
	_RotationMatrix = DirectX::XMMatrixRotationRollPitchYaw(rot, rot, rot);
}

void BowerMesh::SetRotation(float rotX, float rotY, float rotZ)
{
	//Rotation affects rotation matrix
	_RotationMatrix = DirectX::XMMatrixRotationRollPitchYaw(rotX, rotY, rotZ);
}